using System;
using System.Data;

namespace gov.va.med.vbecs.BOL
{
	/// <summary>
	/// Summary description for TestResult.
	/// </summary>
	public class TestResult 
	{
		#region Variables

		DataTable _testResultDataTable;
		DataRow _testResultDataRow;

		#endregion

		#region Constructors 

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/15/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7831"> 
		///		<ExpectedInput>Valid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7832"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// TestResult blank constructor
		/// </summary>
		public TestResult()
		{
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/15/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7833"> 
		///		<ExpectedInput>Valid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7834"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Constructor by test result id
		/// </summary>
		/// <param name="testResultID"></param>
		public TestResult(string testResultID)
		{
			GetTestResultData(testResultID);
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/15/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7835"> 
		///		<ExpectedInput>Valid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7836"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Constructor by DataRow
		/// </summary>
		public TestResult(DataRow dataRow)
		{
			this.LoadFromDataRow(dataRow);
		}

		#endregion

		#region Properties

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/15/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7837"> 
		///		<ExpectedInput>Valid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7838"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// TestResultId
		/// </summary>
		public string TestResultId
		{
			get
			{
				return this._testResultDataRow[Common.VbecsTables.TestResult.TestResultId].ToString();
			}
			set
			{
				this._testResultDataRow[Common.VbecsTables.TestResult.TestResultId] = value;
			}
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/15/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7839"> 
		///		<ExpectedInput>Valid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7840"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// TestResultText
		/// </summary>
		public string TestResultText
		{
			get
			{
				return this._testResultDataRow[Common.VbecsTables.TestResult.TestResultText].ToString();
			}
			set
			{
				this._testResultDataRow[Common.VbecsTables.TestResult.TestResultText] = value;
			}
		}

		#endregion

		#region Methods

		/// <summary>
		///GetTestResultData
		/// </summary>
		/// <param name="testResultID"></param>
		/// <returns></returns>
		private void GetTestResultData(string testResultID)
		{
			_testResultDataTable = DAL.TestResult.GetTestResult(testResultID);
			if (_testResultDataTable.Rows.Count > 0) 
			{
				_testResultDataRow = _testResultDataTable.Rows[0];
			}
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/15/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7841"> 
		///		<ExpectedInput>Valid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7842"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Returns a data table of test results based on patient GUID and division code
		/// </summary>
		/// <param name="patientOrderGuid"></param>
		/// <returns></returns>
		public static DataTable GetTestResults(Guid patientOrderGuid)
		{
			return DAL.TestResult.GetTestResults(patientOrderGuid);
		}
	
		/// <summary>
		/// LoadFromDataRow
		/// </summary>
		/// <param name="dataRow">Data row</param>
		protected void LoadFromDataRow(DataRow dataRow)
		{
			_testResultDataTable = dataRow.Table;
			_testResultDataRow = dataRow;
		}

		#endregion
	}
}
